using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgExpiredAntisera
	/// </summary>
	public class DlgExpiredAntisera : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpConfirm;
		private System.Windows.Forms.TextBox txtComment;
		private System.Windows.Forms.Label lblComment;
		private System.Windows.Forms.GroupBox grpIcon;
		private System.Windows.Forms.Label lblWarningMessage;
		private System.Windows.Forms.TextBox txtExpirationDate;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.PictureBox picWarning;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnContinue;
		private System.Windows.Forms.Button btnRemove;
		private System.Windows.Forms.TextBox txtLotNumber;
		private System.Windows.Forms.Label lblLotNumber;
		private System.Windows.Forms.TextBox txtReagentType;
		private System.Windows.Forms.TextBox txtRack;
		private System.Windows.Forms.Label lblReagentType;
		private System.Windows.Forms.Label lblRack;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private DataRow[] _drLotNumbers;
		private Guid _reagentGUID;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="rackName"></param>
		/// <param name="drLotNumbers"></param>
		public DlgExpiredAntisera(string rackName, DataRow[] drLotNumbers)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			_drLotNumbers = drLotNumbers;
			LoadData(rackName, drLotNumbers[0][ARTIFICIAL.ReagentType].ToString(), drLotNumbers[0][ARTIFICIAL.Lot_Number].ToString(), System.Convert.ToDateTime(drLotNumbers[0][ARTIFICIAL.ExpirationDate]));
			SetComponentProperties();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="rackName"></param>
		/// <param name="reagentGuid"></param>
		/// <param name="reagentType"></param>
		/// <param name="lotNumber"></param>
		/// <param name="lotExpirationDate"></param>
		public DlgExpiredAntisera(string rackName, Guid reagentGuid, 
									string reagentType, string lotNumber, 
									DateTime lotExpirationDate)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			this.txtRack.Visible = false;
			this.lblRack.Visible = false;
			_drLotNumbers = null;
			_reagentGUID = reagentGuid;
			LoadData(rackName, reagentType, lotNumber, lotExpirationDate);
			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgExpiredAntisera));
			this.btnContinue = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnRemove = new System.Windows.Forms.Button();
			this.grpConfirm = new System.Windows.Forms.GroupBox();
			this.txtLotNumber = new System.Windows.Forms.TextBox();
			this.lblLotNumber = new System.Windows.Forms.Label();
			this.txtExpirationDate = new System.Windows.Forms.TextBox();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.txtComment = new System.Windows.Forms.TextBox();
			this.lblComment = new System.Windows.Forms.Label();
			this.txtReagentType = new System.Windows.Forms.TextBox();
			this.txtRack = new System.Windows.Forms.TextBox();
			this.lblReagentType = new System.Windows.Forms.Label();
			this.lblRack = new System.Windows.Forms.Label();
			this.lblWarningMessage = new System.Windows.Forms.Label();
			this.grpIcon = new System.Windows.Forms.GroupBox();
			this.picWarning = new System.Windows.Forms.PictureBox();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.grpConfirm.SuspendLayout();
			this.grpIcon.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(394, 30);
			this.vbecsLogo1.TabIndex = 3;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 287);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// btnContinue
			// 
			this.btnContinue.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnContinue.DialogResult = System.Windows.Forms.DialogResult.Yes;
			this.btnContinue.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnContinue.Image = null;
			this.btnContinue.Location = new System.Drawing.Point(160, 276);
			this.btnContinue.Name = "btnContinue";
			this.btnContinue.Size = new System.Drawing.Size(112, 23);
			this.btnContinue.TabIndex = 6;
			this.btnContinue.Click += new System.EventHandler(this.btnContinue_Click);
			// 
			// btnRemove
			// 
			this.btnRemove.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnRemove.DialogResult = System.Windows.Forms.DialogResult.No;
			this.btnRemove.Location = new System.Drawing.Point(276, 276);
			this.btnRemove.Name = "btnRemove";
			this.btnRemove.Size = new System.Drawing.Size(112, 23);
			this.btnRemove.TabIndex = 7;
			this.btnRemove.Text = "&Remove from Use";
			this.btnRemove.Click += new System.EventHandler(this.btnRemove_Click);
			// 
			// grpConfirm
			// 
			this.grpConfirm.AccessibleDescription = "Confirm Expired Reagent";
			this.grpConfirm.AccessibleName = "Confirm Expired Reagent";
			this.grpConfirm.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpConfirm.Controls.Add(this.txtLotNumber);
			this.grpConfirm.Controls.Add(this.lblLotNumber);
			this.grpConfirm.Controls.Add(this.txtExpirationDate);
			this.grpConfirm.Controls.Add(this.lblExpirationDate);
			this.grpConfirm.Controls.Add(this.txtComment);
			this.grpConfirm.Controls.Add(this.lblComment);
			this.grpConfirm.Controls.Add(this.txtReagentType);
			this.grpConfirm.Controls.Add(this.txtRack);
			this.grpConfirm.Controls.Add(this.lblReagentType);
			this.grpConfirm.Controls.Add(this.lblRack);
			this.grpConfirm.Controls.Add(this.lblWarningMessage);
			this.grpConfirm.Location = new System.Drawing.Point(64, 36);
			this.grpConfirm.Name = "grpConfirm";
			this.grpConfirm.Size = new System.Drawing.Size(324, 234);
			this.grpConfirm.TabIndex = 0;
			this.grpConfirm.TabStop = false;
			// 
			// txtLotNumber
			// 
			this.txtLotNumber.AccessibleDescription = "Lot Number";
			this.txtLotNumber.AccessibleName = "Lot Number";
			this.txtLotNumber.Location = new System.Drawing.Point(84, 100);
			this.txtLotNumber.Name = "txtLotNumber";
			this.txtLotNumber.ReadOnly = true;
			this.txtLotNumber.Size = new System.Drawing.Size(96, 20);
			this.txtLotNumber.TabIndex = 3;
			this.txtLotNumber.Text = "";
			// 
			// lblLotNumber
			// 
			this.lblLotNumber.Location = new System.Drawing.Point(8, 100);
			this.lblLotNumber.Name = "lblLotNumber";
			this.lblLotNumber.Size = new System.Drawing.Size(72, 20);
			this.lblLotNumber.TabIndex = 5;
			this.lblLotNumber.Text = "Lot Number";
			this.lblLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtExpirationDate
			// 
			this.txtExpirationDate.AccessibleDescription = "Expiration Date";
			this.txtExpirationDate.AccessibleName = "Expiration Date";
			this.txtExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpirationDate.Location = new System.Drawing.Point(84, 124);
			this.txtExpirationDate.Name = "txtExpirationDate";
			this.txtExpirationDate.ReadOnly = true;
			this.txtExpirationDate.Size = new System.Drawing.Size(224, 20);
			this.txtExpirationDate.TabIndex = 4;
			this.txtExpirationDate.Text = "";
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(8, 124);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(84, 20);
			this.lblExpirationDate.TabIndex = 7;
			this.lblExpirationDate.Text = "Expiration Date";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtComment
			// 
			this.txtComment.AccessibleDescription = "Override Comment";
			this.txtComment.AccessibleName = "Override Comment";
			this.txtComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComment.Location = new System.Drawing.Point(84, 148);
			this.txtComment.Multiline = true;
			this.txtComment.Name = "txtComment";
			this.txtComment.Size = new System.Drawing.Size(224, 76);
			this.txtComment.TabIndex = 5;
			this.txtComment.Text = "";
			this.txtComment.TextChanged += new System.EventHandler(this.txtComment_TextChanged);
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(8, 148);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(76, 24);
			this.lblComment.TabIndex = 9;
			this.lblComment.Text = "Override Comment*";
			this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtReagentType
			// 
			this.txtReagentType.AccessibleDescription = "Reagent Type";
			this.txtReagentType.AccessibleName = "Reagent Type";
			this.txtReagentType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReagentType.Location = new System.Drawing.Point(84, 76);
			this.txtReagentType.Name = "txtReagentType";
			this.txtReagentType.ReadOnly = true;
			this.txtReagentType.Size = new System.Drawing.Size(224, 20);
			this.txtReagentType.TabIndex = 2;
			this.txtReagentType.Text = "";
			// 
			// txtRack
			// 
			this.txtRack.AccessibleDescription = "Rack";
			this.txtRack.AccessibleName = "Rack";
			this.txtRack.Location = new System.Drawing.Point(84, 48);
			this.txtRack.Name = "txtRack";
			this.txtRack.ReadOnly = true;
			this.txtRack.Size = new System.Drawing.Size(96, 20);
			this.txtRack.TabIndex = 1;
			this.txtRack.Text = "";
			// 
			// lblReagentType
			// 
			this.lblReagentType.Location = new System.Drawing.Point(8, 76);
			this.lblReagentType.Name = "lblReagentType";
			this.lblReagentType.Size = new System.Drawing.Size(80, 20);
			this.lblReagentType.TabIndex = 3;
			this.lblReagentType.Text = "Reagent Type";
			this.lblReagentType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblRack
			// 
			this.lblRack.Location = new System.Drawing.Point(8, 48);
			this.lblRack.Name = "lblRack";
			this.lblRack.Size = new System.Drawing.Size(76, 20);
			this.lblRack.TabIndex = 1;
			this.lblRack.Text = "Rack";
			this.lblRack.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblWarningMessage
			// 
			this.lblWarningMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblWarningMessage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblWarningMessage.Location = new System.Drawing.Point(8, 8);
			this.lblWarningMessage.Name = "lblWarningMessage";
			this.lblWarningMessage.Size = new System.Drawing.Size(308, 28);
			this.lblWarningMessage.TabIndex = 0;
			this.lblWarningMessage.Text = "Selected reagent expired.";
			this.lblWarningMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// grpIcon
			// 
			this.grpIcon.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpIcon.Controls.Add(this.picWarning);
			this.grpIcon.Location = new System.Drawing.Point(4, 36);
			this.grpIcon.Name = "grpIcon";
			this.grpIcon.Size = new System.Drawing.Size(56, 234);
			this.grpIcon.TabIndex = 4;
			this.grpIcon.TabStop = false;
			// 
			// picWarning
			// 
			this.picWarning.Image = ((System.Drawing.Image)(resources.GetObject("picWarning.Image")));
			this.picWarning.Location = new System.Drawing.Point(4, 12);
			this.picWarning.Name = "picWarning";
			this.picWarning.Size = new System.Drawing.Size(45, 45);
			this.picWarning.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picWarning.TabIndex = 0;
			this.picWarning.TabStop = false;
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.DataMember = "";
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// DlgExpiredAntisera
			// 
			this.AcceptButton = this.btnContinue;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnRemove;
			this.ClientSize = new System.Drawing.Size(394, 303);
			this.Controls.Add(this.grpIcon);
			this.Controls.Add(this.grpConfirm);
			this.Controls.Add(this.btnRemove);
			this.Controls.Add(this.btnContinue);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(400, 328);
			this.Name = "DlgExpiredAntisera";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Reagent Expired";
			this.Load += new System.EventHandler(this.DlgExpiredAntisera_Load);
			this.Controls.SetChildIndex(this.btnContinue, 0);
			this.Controls.SetChildIndex(this.btnRemove, 0);
			this.Controls.SetChildIndex(this.grpConfirm, 0);
			this.Controls.SetChildIndex(this.grpIcon, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpConfirm.ResumeLayout(false);
			this.grpIcon.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Set ConfirmationMessage
		/// </summary>
		public string ConfirmationMessage
		{
			set
			{
				this.txtComment.Text = value;
			}
		}

		/// <summary>
		/// Comment text
		/// </summary>
		public string Comment
		{
			get
			{
				return this.txtComment.Text;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Reagent Expired";
			//
			this.RequiredFieldsLabel = true;
			//
			this.btnContinue.Text = "&Continue to Use";
			this.btnContinue.EnabledButton = false;
			this.btnContinue.SetToolTip(Common.StrRes.Tooltips.Common.AntiseraOverrideComment().ResString);
		}

		private void LoadData(string sRackName, string sReagentTypeName, string sLotNumber, DateTime LotExpirationDate)
		{
			this.txtRack.Text = sRackName;
			this.txtReagentType.Text = sReagentTypeName;
			this.txtLotNumber.Text = sLotNumber;
			this.txtExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(LotExpirationDate);
		}

		private void btnRemove_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnContinue_Click(object sender, System.EventArgs e)
		{
			int nCount = 0;
			if (_drLotNumbers != null)
			{
				nCount = _drLotNumbers.Length;
				for(int i=0; i<nCount; i++)
				{
					_drLotNumbers[i][ARTIFICIAL.OverrideComment] = this.txtComment.Text;
				}
			}
			this.Close();
		}

		private void txtComment_TextChanged(object sender, System.EventArgs e)
		{
			if (this.txtComment.Text.Trim() == string.Empty)
			{
				this.btnContinue.EnabledButton = false;
			}
			else
			{
				this.btnContinue.EnabledButton = true;
			}
		}

		private void DlgExpiredAntisera_Load(object sender, System.EventArgs e)
		{
			Common.Utility.MessageBeep();
		}
	}
}

